/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.plant;

import com.agricraft.agricraft.api.codecs.AgriParticleEffect;
import com.agricraft.agricraft.api.codecs.AgriProduct;
import com.agricraft.agricraft.api.codecs.AgriRequirement;
import com.agricraft.agricraft.api.codecs.AgriSeed;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlantModifierFactoryRegistry;
import com.agricraft.agricraft.api.plant.AgriPlantModifierInfo;
import com.agricraft.agricraft.api.plant.IAgriPlantModifier;
import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class AgriPlant {
    public static final Codec<AgriPlant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("mods").forGetter(plant -> plant.mods), (App)AgriSeed.CODEC.listOf().fieldOf("seeds").forGetter(plant -> plant.seeds), (App)Codec.INT.listOf().fieldOf("stages").forGetter(plant -> plant.stages), (App)Codec.INT.fieldOf("harvest_stage").forGetter(plant -> plant.harvestStage), (App)Codec.DOUBLE.fieldOf("growth_chance").forGetter(plant -> plant.growthChance), (App)Codec.DOUBLE.fieldOf("growth_bonus").forGetter(plant -> plant.growthBonus), (App)Codec.BOOL.fieldOf("cloneable").forGetter(plant -> plant.cloneable), (App)Codec.BOOL.optionalFieldOf("fireproof", (Object)false).forGetter(plant -> plant.fireproof), (App)Codec.DOUBLE.fieldOf("spread_chance").forGetter(plant -> plant.spreadChance), (App)AgriProduct.CODEC.listOf().optionalFieldOf("products", List.of()).forGetter(plant -> plant.products), (App)AgriProduct.CODEC.listOf().optionalFieldOf("clip_products", List.of()).forGetter(plant -> plant.clipProducts), (App)AgriRequirement.CODEC.fieldOf("requirement").forGetter(plant -> plant.requirement), (App)AgriPlantModifierInfo.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(plant -> plant.modifierInfos), (App)AgriParticleEffect.CODEC.listOf().optionalFieldOf("particle_effects", List.of()).forGetter(plant -> plant.particleEffects)).apply((Applicative)instance, AgriPlant::new));
    public static final AgriPlant NO_PLANT = new Builder().harvest(0).chances(0.0, 0.0, 0.0).build();
    public static final class_2960 UNKNOWN = new class_2960("agricraft:unknown");
    private final List<String> mods;
    private final List<AgriSeed> seeds;
    private final List<Integer> stages;
    private final int harvestStage;
    private final double growthChance;
    private final double growthBonus;
    private final boolean cloneable;
    private final boolean fireproof;
    private final double spreadChance;
    private final List<AgriProduct> products;
    private final List<AgriProduct> clipProducts;
    private final AgriRequirement requirement;
    private final List<AgriPlantModifierInfo> modifierInfos;
    private final List<AgriParticleEffect> particleEffects;
    private List<IAgriPlantModifier> modifiers;

    public AgriPlant(List<String> mods, List<AgriSeed> seeds, List<Integer> stages, int harvestStage, double growthChance, double growthBonus, boolean cloneable, boolean fireproof, double spreadChance, List<AgriProduct> products, List<AgriProduct> clipProducts, AgriRequirement requirement, List<AgriPlantModifierInfo> modifierInfos, List<AgriParticleEffect> particleEffects) {
        this.mods = mods;
        this.seeds = seeds;
        this.stages = stages;
        this.harvestStage = harvestStage;
        this.growthChance = growthChance;
        this.growthBonus = growthBonus;
        this.cloneable = cloneable;
        this.fireproof = fireproof;
        this.spreadChance = spreadChance;
        this.products = products;
        this.clipProducts = clipProducts;
        this.requirement = requirement;
        this.modifierInfos = modifierInfos;
        this.particleEffects = particleEffects;
    }

    public double getSpreadChance(AgriGrowthStage growthStage) {
        return this.spreadChance;
    }

    public double getGrowthChance(AgriGrowthStage growthStage) {
        return this.growthChance;
    }

    public double getBonusGrowthChance(AgriGrowthStage growthStage) {
        return this.growthBonus;
    }

    public AgriGrowthStage getInitialGrowthStage() {
        return new AgriGrowthStage(0, this.stages.size());
    }

    public AgriGrowthStage getGrowthStageAfterHarvest() {
        return new AgriGrowthStage(this.harvestStage, this.stages.size());
    }

    public int getPlantHeight(AgriGrowthStage stage) {
        if (stage.index() < 0 || stage.index() >= this.stages.size()) {
            return 0;
        }
        return this.stages.get(stage.index());
    }

    public boolean isSeedItem(class_1799 stack) {
        return this.seeds.stream().anyMatch(seed -> seed.isVariant(stack));
    }

    public AgriSeed getSeed(class_1799 stack) {
        return this.seeds.stream().filter(seed -> seed.isVariant(stack)).findFirst().orElse(null);
    }

    public AgriRequirement getGrowthRequirements() {
        return this.requirement;
    }

    public void getAllPossibleProducts(Consumer<class_1799> products) {
        this.products.forEach(product -> Platform.get().getItemsFromLocation(product.item()).forEach(item -> {
            class_1799 itemStack = new class_1799((class_1935)item, product.min());
            if (!product.nbt().method_33133()) {
                itemStack.method_7948().method_10543(product.nbt());
            }
            products.accept(itemStack);
        }));
    }

    public void getHarvestProducts(Consumer<class_1799> products, AgriGrowthStage growthStage, AgriGenome genome, class_5819 random) {
        if (growthStage.isMature()) {
            this.products.stream().filter(product -> product.shouldDrop(random)).forEach(product -> {
                List<class_1792> possible = Platform.get().getItemsFromLocation(product.item());
                class_1792 item = possible.get(random.method_43048(possible.size()));
                class_1799 itemStack = new class_1799((class_1935)item, product.getAmount(random));
                if (!product.nbt().method_33133()) {
                    itemStack.method_7948().method_10543(product.nbt());
                }
                products.accept(itemStack);
            });
        }
    }

    public void getAllPossibleClipProducts(Consumer<class_1799> products) {
        this.clipProducts.forEach(product -> Platform.get().getItemsFromLocation(product.item()).forEach(item -> products.accept(new class_1799((class_1935)item))));
    }

    public void getClipProducts(Consumer<class_1799> products, class_1799 clipper, AgriGrowthStage growthStage, AgriGenome genome, class_5819 random) {
        if (growthStage.isMature()) {
            this.clipProducts.stream().filter(product -> product.shouldDrop(random)).forEach(product -> {
                List<class_1792> possible = Platform.get().getItemsFromLocation(product.item());
                class_1792 item = possible.get(random.method_43048(possible.size()));
                class_1799 itemStack = new class_1799((class_1935)item, product.getAmount(random));
                if (!product.nbt().method_33133()) {
                    itemStack.method_7948().method_10543(product.nbt());
                }
                products.accept(itemStack);
            });
        }
    }

    public boolean allowsCloning(AgriGrowthStage growthStage) {
        return this.cloneable;
    }

    public boolean isFireproof() {
        return this.fireproof;
    }

    public void spawnParticles(AgriCrop crop, class_5819 random) {
        AgriGrowthStage stage = crop.getGrowthStage();
        class_1937 world = crop.method_10997();
        if (stage.index() == -1 || world == null) {
            return;
        }
        this.particleEffects.stream().filter(effect -> effect.allowParticles(stage.index())).forEach(effect -> {
            class_2396<?> particle = Platform.get().getParticleType(new class_2960(effect.particle()));
            if (!(particle instanceof class_2394)) {
                return;
            }
            for (int amount = 0; amount < 3; ++amount) {
                if (!(random.method_43058() < effect.probability())) continue;
                class_2338 pos = crop.method_11016();
                double x = (double)pos.method_10263() + 0.5 + (double)(random.method_43056() ? 1 : -1) * effect.deltaX() * random.method_43058();
                double y = (double)pos.method_10264() + 0.5 + effect.deltaY() * random.method_43058();
                double z = (double)pos.method_10260() + 0.5 + (double)(random.method_43056() ? 1 : -1) * effect.deltaZ() * random.method_43058();
                world.method_8406((class_2394)particle, x, y, z, 0.0, 0.0, 0.0);
            }
        });
    }

    public boolean allowHarvest(AgriGrowthStage growthStage, @Nullable class_1309 entity) {
        return growthStage.isMature();
    }

    public boolean allowsClipping(AgriGrowthStage growthStage, class_1799 clipper, @Nullable class_1309 entity) {
        return growthStage.isMature();
    }

    public Stream<IAgriPlantModifier> getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<IAgriPlantModifier>();
            this.modifierInfos.stream().map(AgriPlantModifierFactoryRegistry::construct).filter(Optional::isPresent).map(Optional::get).forEach(modifier -> this.modifiers.add((IAgriPlantModifier)modifier));
        }
        return this.modifiers.stream();
    }

    public int getBrightness(AgriCrop crop) {
        return this.getModifiers().mapToInt(modifier -> modifier.getBrightness(crop)).max().orElse(0);
    }

    public int getRedstonePower(AgriCrop crop) {
        return this.getModifiers().mapToInt(modifier -> modifier.getRedstonePower(crop)).max().orElse(0);
    }

    public void onPlanted(AgriCrop crop, @Nullable class_1309 entity) {
        this.getModifiers().forEach(modifier -> modifier.onPlanted(crop, entity));
    }

    public void onSpawned(AgriCrop crop) {
        this.getModifiers().forEach(modifier -> modifier.onSpawned(crop));
    }

    public void onRandomTick(AgriCrop crop, class_5819 random) {
        this.getModifiers().forEach(modifier -> modifier.onRandomTick(crop, random));
    }

    public void onGrowth(AgriCrop crop) {
        this.getModifiers().forEach(modifier -> modifier.onGrowth(crop));
    }

    public void onRemoved(AgriCrop crop) {
        this.getModifiers().forEach(modifier -> modifier.onRemoved(crop));
    }

    public void onHarvest(AgriCrop crop, @Nullable class_1309 entity) {
        this.getModifiers().forEach(modifier -> modifier.onHarvest(crop, entity));
    }

    public void onClipped(AgriCrop crop, class_1799 clipper, @Nullable class_1309 entity) {
        this.getModifiers().forEach(modifier -> modifier.onClipped(crop, clipper, entity));
    }

    public void onFertilized(AgriCrop crop, class_1799 fertilizer, class_5819 random) {
        this.getModifiers().forEach(modifier -> modifier.onFertilized(crop, fertilizer, random));
    }

    public void onBroken(AgriCrop crop, @Nullable class_1309 entity) {
        this.getModifiers().forEach(modifier -> modifier.onBroken(crop, entity));
    }

    public void onEntityCollision(AgriCrop crop, class_1297 entity) {
        this.getModifiers().forEach(modifier -> modifier.onEntityCollision(crop, entity));
    }

    public Optional<class_1269> onRightClickPre(AgriCrop crop, class_1799 stack, @Nullable class_1297 entity) {
        return this.getModifiers().map(modifier -> modifier.onRightClickPre(crop, stack, entity)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<class_1269> onRightClickPost(AgriCrop crop, class_1799 stack, @Nullable class_1297 entity) {
        return this.getModifiers().map(modifier -> modifier.onRightClickPost(crop, stack, entity)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AgriPlant that = (AgriPlant)obj;
        return Objects.equals(this.mods, that.mods) && Objects.equals(this.seeds, that.seeds) && Objects.equals(this.stages, that.stages) && this.harvestStage == that.harvestStage && Double.doubleToLongBits(this.growthChance) == Double.doubleToLongBits(that.growthChance) && Double.doubleToLongBits(this.growthBonus) == Double.doubleToLongBits(that.growthBonus) && this.cloneable == that.cloneable && this.fireproof == that.fireproof && Double.doubleToLongBits(this.spreadChance) == Double.doubleToLongBits(that.spreadChance) && Objects.equals(this.products, that.products) && Objects.equals(this.clipProducts, that.clipProducts) && Objects.equals(this.requirement, that.requirement) && Objects.equals(this.modifierInfos, that.modifierInfos) && Objects.equals(this.particleEffects, that.particleEffects);
    }

    public int hashCode() {
        return Objects.hash(this.mods, this.seeds, this.stages, this.harvestStage, this.growthChance, this.growthBonus, this.cloneable, this.fireproof, this.spreadChance, this.products, this.clipProducts, this.requirement, this.modifierInfos, this.particleEffects);
    }

    public String toString() {
        return "AgriPlant[mods=" + this.mods + ", seeds=" + this.seeds + ", stages=" + this.stages + ", harvestStage=" + this.harvestStage + ", growthChance=" + this.growthChance + ", growthBonus=" + this.growthBonus + ", cloneable=" + this.cloneable + ", fireproof=" + this.fireproof + ", spreadChance=" + this.spreadChance + ", products=" + this.products + ", clipProducts=" + this.clipProducts + ", requirement=" + this.requirement + ", modifiers=" + this.modifierInfos + ", particleEffects=" + this.particleEffects + "]";
    }

    public static class Builder {
        List<String> mods = new ArrayList<String>();
        List<AgriSeed> seeds = new ArrayList<AgriSeed>();
        List<Integer> stages = new ArrayList<Integer>();
        int harvestStage = 4;
        double growthChance = 0.75;
        double growthBonus = 0.025;
        double spreadChance = 0.1;
        boolean cloneable = true;
        boolean fireproof = false;
        List<AgriProduct> products = new ArrayList<AgriProduct>();
        List<AgriProduct> clipProducts = List.of();
        AgriRequirement requirement = AgriRequirement.NO_REQUIREMENT;
        List<AgriPlantModifierInfo> modifiers = List.of();
        List<AgriParticleEffect> particleEffects = List.of();

        public static Builder from(AgriPlant plant) {
            return new Builder().mods(plant.mods.toArray(new String[0])).seeds(plant.seeds.toArray(new AgriSeed[0])).stages(plant.stages.toArray(new Integer[0])).harvest(plant.harvestStage).chances(plant.growthChance, plant.growthBonus, plant.spreadChance).cloneable(plant.cloneable).fireproof(plant.fireproof).products(plant.products.toArray(new AgriProduct[0])).clips(plant.clipProducts.toArray(new AgriProduct[0])).requirement(plant.requirement).modifiers(plant.modifierInfos.toArray(new AgriPlantModifierInfo[0])).particles(plant.particleEffects.toArray(new AgriParticleEffect[0]));
        }

        public AgriPlant build() {
            return new AgriPlant(this.mods, this.seeds, this.stages, this.harvestStage, this.growthChance, this.growthBonus, this.cloneable, this.fireproof, this.spreadChance, this.products, this.clipProducts, this.requirement, this.modifiers, this.particleEffects);
        }

        public Builder mods(String ... mods) {
            Collections.addAll(this.mods, mods);
            return this;
        }

        public Builder seeds(AgriSeed ... seeds) {
            Collections.addAll(this.seeds, seeds);
            return this;
        }

        public Builder stages(Integer ... stages) {
            Collections.addAll(this.stages, stages);
            return this;
        }

        public Builder stages16() {
            for (int i = 2; i < 17; i += 2) {
                this.stages.add(i);
            }
            return this;
        }

        public Builder harvest(int stage) {
            this.harvestStage = stage;
            return this;
        }

        public Builder chances(double growth, double growthBonus, double spread) {
            this.growthChance = growth;
            this.growthBonus = growthBonus;
            this.spreadChance = spread;
            return this;
        }

        public Builder cloneable(boolean cloneable) {
            this.cloneable = cloneable;
            return this;
        }

        public Builder fireproof(boolean fireproof) {
            this.fireproof = fireproof;
            return this;
        }

        public Builder products(AgriProduct ... products) {
            Collections.addAll(this.products, products);
            return this;
        }

        public Builder clips(AgriProduct ... clips) {
            this.clipProducts = List.of(clips);
            return this;
        }

        public Builder requirement(AgriRequirement requirement) {
            this.requirement = requirement;
            return this;
        }

        public Builder modifiers(AgriPlantModifierInfo ... modifiers) {
            this.modifiers = List.of(modifiers);
            return this;
        }

        public Builder particles(AgriParticleEffect ... particles) {
            this.particleEffects = List.of(particles);
            return this;
        }
    }
}

